 /* '12 Game.h' */

 /* Plik standardowego nagwka Windows  */
#include <windows.h>
 /* Plik standardowego nagowka wejcia-wyjcia */
#include <stdio.h>
 /* Plik nagwka strumienia pliku */
#include <fstream.h>

 /* Plik nagwka ConLib */
#include "ConLib.h"
 /* Plik nagwka CPlayer  */
#include "12 Player.h"

 /* Wyliczenie statusw gry */
enum GameStatus
{
 GameMainMenu     = 1,
 GameRunning      = 2,
 GamePaused       = 3,
 GameWon          = 4,
 GameLostLife     = 5,
 GameLost         = 6,
 GameExit         = 7,
 GameSplashScreen = 8
};

 /* Wyliczenie poziomw trudnoci */
enum GameDifficulty
{
 GameEasy         = 1,
 GameMedium       = 2,
 GameDifficult    = 3,
};

 /* Klasa bazowa gry */
class CGame
{
private:

  /* Informacje we/wy */
 ConLib *   m_Console;
 int        m_LastAction;

  /* Informacje o grze */
 int        m_GameStatus;
 COORD      m_Arena;
 CPlayer    m_Player;
 COORD *    m_Monsters;
 int        m_MonstersNumber;

public:

  /* Konstruktory / Destruktory */
 CGame ();
 CGame (ConLib * Console);
 ~CGame ();

  /* Pokazuj odpowiedni informacje w zalenoci od statusu gry */
 void ShowSplash (void);
 void ShowMenu (void);
 void ShowGame (void);
 void ShowWon (void);
 void ShowLostLife (void);
 void ShowLost (void);
 void ShowExit (void);
 void Show (void);

  /* Przetwarzaj tur w zalenoci od statusu gry */
 void ProcessSplash (void);
 void ProcessMenu (void);
 void ProcessGame (void);
 void ProcessWon (void);
 void ProcessLostLife (void);
 void ProcessLost (void);
 void ProcessExit (void);
 void Process (void);

  /* Ustawia inforacje o konsoli */
 void SetConsole (ConLib * Console);

  /* Metody klasy Game */
 void StartNewGame (int Difficulty);
 void EndGame (void);
 void CheckCollisions ();
 int GetAction (void);
 int GetStatus (void);
 void MoveMonsters (void);

  /* Metody do zapisu i odczytu gry */
	void Load (void);
	void Save (void);
};